function processEmails() {
    
    //build query to search emails to process
    var query = 'in:Notes'; //the search term you would use when filtering in gmail
    var queue = GmailApp.search(query);
    
    //Begin processing all emails 
    for (var email in queue) {
        // Get data from email
        var mesgs = queue[email].getMessages(),
            subject = mesgs[0].getSubject(),
            body = mesgs[0].getPlainBody(),
            from = mesgs[0].getFrom(),
            date = mesgs[0].getDate(),
            emailAddress = from.match(/(?<=<\s*).*?(?=\s*>)/gs);
        
        // Get person reference from CXM if user is found
        try {
            var purl = UrlFetchApp.fetch('https://yourAPI.com/api/service-api/<yourAPIName>/user/' + emailAddress + '?key=<yourKey>');
            var pdata = JSON.parse(purl);
            var personReference = pdata.person.reference;
        } catch (err) {
            var personReference = "";
        }
        
        // Remove & add labels to avoid re-processing    
        queue[email].addLabel(GmailApp.getUserLabelByName('Processed'));
        queue[email].removeLabel(GmailApp.getUserLabelByName('Notes'));
        
        // Create CXM Case
        var url = 'https://yourAPI.com/api/service-api/<yourAPIName>/<yourCaseType>/case/create?key=<yourKey>';
        //JSON to create case
        var data = {
            "person": "" + personReference + "", 
            "message": "" + subject + "",
            "body": "" + body + ""
        }
        var payload = JSON.stringify(data);
        var headers = {
            "Content-Type": "application/json",
        };
        var options = {
            "method": "POST",
            "headers": headers,
            "payload": payload,
            muteHttpExceptions: true
        };
        var response = UrlFetchApp.fetch(url, options);
        
        // get the case reference to add attachements to
        var caseReference = JSON.parse(response).reference;
        
      
      //For every email, add each attachment to newly created case
        for (var attachments in mesgs) {
            var attachments = mesgs[attachments].getAttachments();
            for (var attachment in attachments) {
                var attachment = attachments[attachment];
                
                //add attachemnt to case
                var aurl = "https://yourAPI.com/api/service-api/<yourAPIName>/case/" + caseReference + "/attach?key=<yourKey>";
                var adata = {
                    file: attachment,
                    json: JSON.stringify({
                        "type": "photo",
                        "name": "attachment",
                        "description": "the description of the file"
                    })
                };
                var apayload = adata;
                var aoptions = {
                    method: "POST",
                    payload: apayload,
                    file: attachment,
                    muteHttpExceptions: true
                };
                var res = UrlFetchApp.fetch(aurl, aoptions)
                    .getContentText();
            }
        }
    }
}
